/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.network;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import tictim.paraglider.recipe.bargain.StatueBargainContainer;

public class UpdateBargainPreviewMsg {
    private final Map<ResourceLocation, Data> updated = new HashMap<ResourceLocation, Data>();

    public static UpdateBargainPreviewMsg read(PacketBuffer buf) {
        UpdateBargainPreviewMsg msg = new UpdateBargainPreviewMsg();
        int size = buf.readUnsignedByte();
        for (int i = 0; i < size; ++i) {
            msg.add(buf.func_192575_l(), Data.readData(buf));
        }
        return msg;
    }

    public void add(ResourceLocation key, StatueBargainContainer.Preview preview, boolean includeItemDemands) {
        if (this.updated.size() >= 256) {
            throw new IllegalArgumentException("Too many recipes have been written in single packet");
        }
        this.updated.put(key, new Data(preview.canBargain(), includeItemDemands ? preview.getDemands() : null));
    }

    public void add(ResourceLocation key, Data data) {
        this.updated.put(key, data);
    }

    public Map<ResourceLocation, Data> getUpdated() {
        return this.updated;
    }

    public void write(PacketBuffer buf) {
        buf.writeByte(this.updated.size());
        for (Map.Entry<ResourceLocation, Data> e : this.updated.entrySet()) {
            buf.func_192572_a(e.getKey());
            e.getValue().write(buf);
        }
    }

    public static final class Data {
        private final boolean canBargain;
        @Nullable
        private final StatueBargainContainer.ItemDemand[] demands;

        private static Data readData(PacketBuffer buf) {
            StatueBargainContainer.ItemDemand[] demands;
            boolean canBargain = buf.readBoolean();
            if (buf.readBoolean()) {
                demands = new StatueBargainContainer.ItemDemand[buf.func_150792_a()];
                for (int i = 0; i < demands.length; ++i) {
                    demands[i] = Data.readItemDemand(buf);
                }
            } else {
                demands = null;
            }
            return new Data(canBargain, demands);
        }

        private static StatueBargainContainer.ItemDemand readItemDemand(PacketBuffer buf) {
            ItemStack[] previewItems = new ItemStack[buf.func_150792_a()];
            for (int i = 0; i < previewItems.length; ++i) {
                previewItems[i] = buf.func_150791_c();
            }
            int quantity = buf.func_150792_a();
            int count = buf.func_150792_a();
            return new StatueBargainContainer.ItemDemand(previewItems, quantity, count);
        }

        private static void writeItemDemand(StatueBargainContainer.ItemDemand itemDemand, PacketBuffer buf) {
            buf.func_150787_b(itemDemand.getPreviewItems().length);
            for (ItemStack s : itemDemand.getPreviewItems()) {
                buf.func_150788_a(s);
            }
            buf.func_150787_b(itemDemand.getQuantity());
            buf.func_150787_b(itemDemand.getCount());
        }

        private Data(boolean canBargain, @Nullable StatueBargainContainer.ItemDemand[] demands) {
            this.canBargain = canBargain;
            this.demands = demands;
        }

        public boolean canBargain() {
            return this.canBargain;
        }

        @Nullable
        public StatueBargainContainer.ItemDemand[] getDemands() {
            return this.demands;
        }

        public void write(PacketBuffer buf) {
            buf.writeBoolean(this.canBargain);
            buf.writeBoolean(this.demands != null);
            if (this.demands != null) {
                buf.func_150787_b(this.demands.length);
                for (StatueBargainContainer.ItemDemand d : this.demands) {
                    Data.writeItemDemand(d, buf);
                }
            }
        }
    }
}

